<?php
include 'db.php'; 

$invoice_id = $_GET['invoice_id'] ?? null;

// Check if invoice_id is provided
if (!$invoice_id) {
    echo json_encode(["status" => "error", "message" => "Invoice ID is required"]);
    exit;
}

// Prepare response array
$response = [
    "status" => "error",
    "message" => "No invoice found for this ID"
];

// Query the `invoice` table to get invoice data for the user and specific invoice_id
$invoice_query = "
    SELECT 
        i.*, 
        c.displayname, 
        c.phoneno, 
        c.address, 
        c.city, 
        c.state, 
        c.pincode, 
        SUM(p.Payment_amount) AS customerpaid
    FROM 
        invoice i
    LEFT JOIN 
        payment p ON i.invoice_id = p.Invoice_id
    LEFT JOIN 
        customer c ON i.user_id = c.id
    WHERE 
        i.Delete_status = 0 AND i.invoice_id = '$invoice_id'
    GROUP BY 
        i.invoice_id
    ORDER BY 
        i.Created_date DESC;
";

$invoice_result = mysqli_query($conn, $invoice_query);

if ($invoice_result && mysqli_num_rows($invoice_result) > 0) {
    $invoice = mysqli_fetch_assoc($invoice_result);
    
    // Fetch invoice data for the particular invoice
    $invoice_data_query = "
        SELECT * FROM invoice_data
        WHERE invoice_id = '$invoice_id' AND Delete_status = 0
    ";
    
    $invoice_data_result = mysqli_query($conn, $invoice_data_query);
    
    $invoice_data = [];
    if ($invoice_data_result && mysqli_num_rows($invoice_data_result) > 0) {
        while ($data = mysqli_fetch_assoc($invoice_data_result)) {
            $invoice_data[] = $data;
        }
    }
    
    // Fetch payments related to the invoice
    $paymentsQuery = "
        SELECT
            pc.Payment_date,
            pc.Payment_type,
            pc.Payment_amount
        FROM
            payment pc
        WHERE
            pc.Invoice_id = '$invoice_id';
    ";
    
    $paymentResult = mysqli_query($conn, $paymentsQuery);
    
    $payments = [];
    if ($paymentResult && mysqli_num_rows($paymentResult) > 0) {
        while ($row = mysqli_fetch_assoc($paymentResult)) {
            $payments[] = [
                'paymentdate' => htmlspecialchars($row['Payment_date']),
                'paymenttype' => htmlspecialchars($row['Payment_type']),
                'amount' => htmlspecialchars($row['Payment_amount']),
            ];
        }
    }

    // Add invoice data and payment data to the invoice array
    $invoice['invoice_data'] = $invoice_data;
    $invoice['payment'] = $payments;

    // Return success and the invoice data
    $response['status'] = "success";
    $response['message'] = "Invoice fetched successfully";
    $response['data'] = $invoice;
} else {
    $response['message'] = "Invoice not found for this user";
}

// Return the response as JSON
echo json_encode($response);
?>
